#include <bits/stdc++.h>

using namespace std;

typedef long long ll;

const int MAXN = 1000000;

struct Grana {
    int u, v;
    int drugi(int i) { return i ^ u ^ v; }
};

vector<Grana> grane;
vector<vector<int>> graf(MAXN), pripada;
vector<vector<int>> compressed_graph;
int visited[MAXN], lowlink[MAXN], vreme[MAXN], is_cut[MAXN], koren[MAXN];
int tajmer, broj_komponenti;
stack<int> stek;
vector<int> roots;

void izvuci(int e) {
    int r = broj_komponenti++;
    pripada.emplace_back();
    while (true) {
        int e2 = stek.top();
        stek.pop();
        roots[e2] = r;
        koren[grane[e2].u] = r;
        koren[grane[e2].v] = r;
        pripada[r].push_back(grane[e2].u);
        pripada[r].push_back(grane[e2].v);
        if (e == e2) break;
    }
    sort(pripada[r].begin(), pripada[r].end());
    pripada[r].erase(unique(pripada[r].begin(), pripada[r].end()), pripada[r].end());
}

void dfs_articulation(int node, int parent = -1) {
    lowlink[node] = vreme[node] = tajmer++;
    visited[node] = 1;
    int children = 0;

    for (int e : graf[node]) {
        int next = grane[e].drugi(node);
        if (e == parent || visited[next] == 2) continue;
        stek.push(e);
        if (visited[next]) {
            lowlink[node] = min(lowlink[node], vreme[next]);
        } else {
            children++;
            dfs_articulation(next, e);
            lowlink[node] = min(lowlink[node], lowlink[next]);
            if (lowlink[next] >= vreme[node]) {
                is_cut[node] = 1;
                izvuci(e);
            }
        }
    }
    visited[node] = 2;
    if (parent == -1) is_cut[node] = (children > 1);
}

void priprema(int n) {
    compressed_graph.resize(n);
    roots.resize(grane.size());
    for (int i = 0; i < n; i++) {
        if (!visited[i]) dfs_articulation(i);
    }
    for (int i = 0; i < n; i++) {
        if (is_cut[i]) {
            koren[i] = broj_komponenti++;
            pripada.emplace_back(vector<int>{i});
        }
    }
    for (int i = 0; i < n; i++) {
        if (is_cut[i]) {
            for (int e : graf[i]) {
                compressed_graph[roots[e]].push_back(koren[i]);
                compressed_graph[koren[i]].push_back(roots[e]);
            }
        }
    }
    for (int i = 0; i < broj_komponenti; i++) {
        sort(compressed_graph[i].begin(), compressed_graph[i].end());
        compressed_graph[i].erase(unique(compressed_graph[i].begin(), compressed_graph[i].end()), compressed_graph[i].end());
    }
}

pair<int, int> find_median(int A, int B, const vector<int>& a) {
    multiset<int> values;
    while (A != B) {
        for (int v : pripada[A]) values.insert(a[v]);
        A = koren[A];
    }
    for (int v : pripada[A]) values.insert(a[v]);

    auto it = values.begin();
    advance(it, values.size() / 2);
    return {values.size(), *it};
}

vector<int> a(MAXN);

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);

    int n, m, q, p;
    cin >> n >> m >> q >> p;

    for (int i = 0; i < n; i++) cin >> a[i];

    grane.reserve(m);
    for (int i = 0; i < m; i++) {
        int u, v;
        cin >> u >> v;
        u--, v--;
        grane.push_back({u, v});
        graf[u].push_back(i);
        graf[v].push_back(i);
    }

    priprema(n);

    int prev = 0;
    while (q--) {
        int A, B;
        cin >> A >> B;
        A = (A + prev * p) % n;
        B = (B + prev * p) % n;

        if (A == B) {
            cout << a[A] << "\n";
            prev = a[A];
            continue;
        }

        A = koren[A];
        B = koren[B];
        auto [size, median] = find_median(A, B, a);
        cout << median << "\n";
        prev = median;
    }

    return 0;
}